
function [PC, Amean, V, signals] = pca1(data)
 % PCA1: Perform PCA using covariance. 

 %Get size of Matrix
 [n, q] = size(data); 
 
 %Standardise data matrix
 Amean=mean(data);
 
 Astd=std(data);
  
 B=(data-repmat(Amean,[n,1]));
 
 %Extract PC coefcients and variances
 [PC, V]=eig(cov(B));
 
 
 
 V=diag(V);
 
 %Construct Component series, first components is in last series
 signals=B*PC;
 
 %Scale factors
 PC=PC./repmat(std(signals),[q,1]);
 signals=(signals-repmat(mean(signals),[n,1]))./repmat(std(signals),[n,1]);